package mybeaverbot;

import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.*;
import java.util.ArrayList;
import java.util.List;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import java.util.Random;
import java.util.logging.Logger;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour
{
	Object mutex = new Object();
	Random random = new Random();
	
	WarshallMap map = null;
	
	public MyBehaviour(String name, Logger log, SPoshBot bot)
	{
		super(name, log, bot);
	}

	
	/**
	 * Initializes map and performs Floyd-Warshall algorithm.
	 */
	public void initializeMap()
	{
		if (map == null)
			map = new WarshallMap(log, bot, bot.getMemory().getKnownNavPoints());
		
	}
	
	/**
	 * Resets internal bot logic. This should be called when bot dies.
	 */
	public void resetLogic()
	{
		synchronized(mutex) {
			log.fine("Reset logic.");
			running = false;
			betterWeapon = null;
			lastEnemyLocation = null;
			lastSeenEnemy = null;
			fleeNavPoint = null;
			stuckCounter = 0;
			runToMedKits.clear();
			priorityListRefreshCounter = 0;
			priorityList.clear();
		}
	}

	
	public void playerKilled()
	{
		synchronized(mutex) {
			lastEnemyLocation = null;
			lastSeenEnemy = null;
			fleeNavPoint = null;
		}
	}
	
	
	@Override
	public boolean action_doNothing()
	{
		try {
			Thread.sleep(250);
		} catch (InterruptedException e) {
		}
		return true;
	}

	@Override
	public boolean sense_fail()
	{
		return false;
	}

	@Override
	public boolean sense_succeed()
	{
		return true;
	}
	
	


	/*
	 * Running and path finding.
	 */
	
	protected boolean running = false;
	
	protected boolean preparePathTo(NavPoint dest)
	{
		if (dest == null) return false;

		NavPoint from = null;
		float minDist = Float.POSITIVE_INFINITY;
		for (NavPoint np : bot.getMemory().seeAllNavPoints())
			if (map.isReachable(np)) {
				float dist = map.getDistance(np, dest);
				if (dist < minDist) {
					from = np;
					minDist = dist;
				}	
			}
		
		if (from == null)
			from = bot.getMap().nearestNavPoint(bot.getMemory().getAgentLocation());
		
		ArrayList<NavPoint> path = new ArrayList<NavPoint>();
		if (!map.getPath(from, dest, path)) return false;
		
		if ((path.size() > 1) && (map.isReachable(path.get(1)))) path.remove(0);

/*
		String str = "Path is: ";
		for (NavPoint np : path)
			str += np.UnrealID + ",";
		log.finer(str);
 */
		
		if (!path.isEmpty())
			bot.getBody().turnToLocation(path.get(0).location);
		
		bot.getMap().initializeRunAlongPath(path);
		return true;
	}
	

	protected NavPoint getNearestNavPoint()
	{
		ArrayList<NavPoint> navPoints = bot.getMemory().seeAllNavPoints();
		if ((navPoints == null) || navPoints.isEmpty())
			navPoints = bot.getMemory().getKnownNavPoints();
		
		Triple location = bot.getMemory().getAgentLocation();
		NavPoint res = null;
		double minDist = Double.POSITIVE_INFINITY;
		for (NavPoint np : navPoints)
			if (map.isReachable(np)) {
				double dist = Triple.distanceInSpace(location, np.location);
				if (dist < minDist) {
					res = np;
					minDist = dist;
				}
			}
		
		if (res == null) res = bot.getMap().nearestNavPoint(bot.getMemory().getAgentLocation());
		return res;
	}
	
	
	/*
	 * Combat oriented methods.
	 */
	
	Triple lastEnemyLocation = null;
	Player lastSeenEnemy = null;
	
	public boolean sense_seeEnemy()
	{
		synchronized(mutex) {
			if (lastSeenEnemy != null)
				lastSeenEnemy = bot.getMemory().getSeePlayer(lastSeenEnemy.getID());

			if (lastSeenEnemy == null)
				lastSeenEnemy = bot.getMemory().getSeeEnemy();

			return (lastSeenEnemy != null);
		}
	}
		
	protected AddWeapon betterWeapon = null;
	
	public boolean sense_hasBetterWeapon()
	{
		synchronized(mutex) {
			if ((lastSeenEnemy == null) || (lastSeenEnemy.location == null))
				return false;

			Triple loc = bot.getMemory().getAgentLocation();
			lastEnemyLocation = lastSeenEnemy.location;
		 	betterWeapon = bot.getMemory().getBetterWeapon(loc, lastEnemyLocation);
			return (betterWeapon != null);
		}
	}
	
	public boolean action_rearm()
	{
		synchronized(mutex) {
			if (betterWeapon != null) {
				log.fine("Changing weapon to: ");
				bot.getBody().changeWeapon(betterWeapon);
			}
		}
		return true;
	}
	
	
	public boolean sense_inShapeForCombat()
	{
		return (bot.getMemory().getAgentHealth() > 70) && bot.getMemory().hasAnyLoadedWeapon();
	}
	
	protected NavPoint fleeNavPoint = null;

	public boolean action_attack()
	{
		synchronized(mutex) {
			if (lastSeenEnemy != null)
				lastSeenEnemy = bot.getMemory().getSeePlayer(lastSeenEnemy.ID);
			if ((lastSeenEnemy == null) || (lastSeenEnemy.location == null))
				return false;

			log.fine("The bot is attacking enemy.");
			lastEnemyLocation = lastSeenEnemy.location;
			bot.getBody().shoot(lastSeenEnemy);
		
			running = false;
			if (Triple.distanceInSpace(bot.getMemory().getAgentLocation(), lastEnemyLocation) > 1000)
				bot.getBody().runToLocation(lastEnemyLocation);
	
			fleeNavPoint = null;
			return true;
		}
	}
	

	public boolean action_flee()
	{
		synchronized(mutex) {
			if (lastSeenEnemy != null)
				lastSeenEnemy = bot.getMemory().getSeePlayer(lastSeenEnemy.ID);
			if ((lastSeenEnemy == null) || (lastSeenEnemy.location == null))
				return false;

			log.fine("The bot flees.");
			lastEnemyLocation = lastSeenEnemy.location;
		
			if ((fleeNavPoint != null) && (Triple.distanceInSpace(bot.getMemory().getAgentLocation(), fleeNavPoint.location)) < 50)
				fleeNavPoint = null;
		
			if (fleeNavPoint == null) {
				ArrayList<NavPoint> navPoints = bot.getMemory().seeAllNavPoints();
				double maxDist = Double.POSITIVE_INFINITY;
				for (NavPoint np : navPoints)
					if (map.isReachable(np)) {
						double dist = Triple.distanceInSpace(lastEnemyLocation, np.location);
						if (dist > maxDist) {
							fleeNavPoint = np;
							maxDist = dist;
						}
					}		
			}
		
			if (fleeNavPoint == null)
				fleeNavPoint = bot.getMemory().getSeeNavPoint();
		
			if (fleeNavPoint != null) {
				bot.getBody().shoot(lastSeenEnemy);
				bot.getBody().strafeToLocation(fleeNavPoint.location, lastEnemyLocation);
				return true;
			} else
				return false;
		}
	}


	public boolean sense_knowLastEnemyPosition()
	{
		synchronized(mutex) {	
			return (lastEnemyLocation != null);
		}
	}

	public boolean action_pursue()
	{
		synchronized(mutex) {
			if (lastEnemyLocation != null) {
				
				if (!running) {
					log.fine("Preparing pursue path.");
					running = this.preparePathTo(bot.getMap().nearestNavPoint(lastEnemyLocation));
				}

				if (running)
					log.fine("The bot is on pursue.");

				if (running && !bot.getMap().runAlongPath()) {
					log.fine("The pursue is over.");
					running = false;
				}

				if (!running)
					lastEnemyLocation = null;
			}
		}		
		return true;
	}
	
	
	
	/*
	 * First aid atention.
	 */
	
	protected ArrayList<Health> runToMedKits = new ArrayList<Health>();
	
	public boolean sense_badlyWounded()
	{
		synchronized(mutex) {
			if (bot.getMemory().getAgentHealth() > 80) {
				runToMedKits.clear();
				return false;
			} else {
				log.fine("The bot is badly wounded.");
				return true;
			}
		}
	}

	protected void bringNearestMedKitAsFirst()
	{
		if (runToMedKits.isEmpty()) return;

		// Find nearest med kit.
		NavPoint nearest = getNearestNavPoint();
		int idx = 0;
		float minDist = map.getDistance(nearest, runToMedKits.get(0).navPoint);
		for (int i = 1; i < runToMedKits.size(); i++) {
			float dist = map.getDistance(nearest, runToMedKits.get(i).navPoint);
			if (dist < minDist) {
				minDist = dist;
				idx = i;
			}
		}
		
		// Bring nearest medkit to front.
		if (idx > 0) {
			Health tmp = runToMedKits.get(0);
			runToMedKits.set(0, runToMedKits.get(idx));
			runToMedKits.set(idx, tmp);
		}
				
	}
	
	public boolean action_runForMedkit()
	{		
		synchronized(mutex) {
			// Prepare med kits.
			if (runToMedKits.isEmpty()) {
				// Try get some reachable medkit first.
				runToMedKits.addAll(bot.getMemory().getSeeHealths());
			
				// Otherwise add all medkits.
				if (runToMedKits.isEmpty())
					runToMedKits.addAll(bot.getMemory().getKnownHealths());
			
				bringNearestMedKitAsFirst();
				running = false;
			}

			if (runToMedKits.isEmpty()) {
				log.info("Three are no med kits!");
				return false;
			}
		
			if (!running && !runToMedKits.isEmpty())
				running = preparePathTo(runToMedKits.get(0).navPoint);
	
			if (running)
				log.fine("The bot is running for a medkit.");
		
			if (running && !bot.getMap().runAlongPath()) {
				running = false;
				log.finer("Runing for medkit terminated.");
			}

			if (!running) {
				runToMedKits.remove(0);
				bringNearestMedKitAsFirst();
			}
		}		
		return true;
	}
	
	
	/*
	 * Picking items in the sight.
	 */
	
	protected Item seenItem = null;

	protected Item getNearestReachableItem(List<? extends Item> items)
	{
		Item res = null;
		double minDist = Float.POSITIVE_INFINITY;
		for (Item item : items) {
			double dist = Triple.distanceInSpace(bot.getMemory().getAgentLocation(), item.location);
			if (item.isReachable() && (dist < minDist)) {
				minDist = dist;
				res = item;
			}
		}
		return res;
	}

	
	public boolean sense_seeUsefulItem()
	{
		synchronized(mutex) {
			// See Health?
			List<Health> seenHealths;
			if (bot.getMemory().getAgentHealth() >= 100) {
				seenHealths = new ArrayList<Health>();
				for(Health h : bot.getMemory().getSeeHealths())
					if (h.boostable && h.reachable)
						seenHealths.add(h);
			} else
				seenHealths = bot.getMemory().getSeeHealths();
			
			seenItem = getNearestReachableItem(seenHealths);
			if (seenItem != null) return true;


			// See Weapon?
			List<Weapon> seenWeapons = new ArrayList<Weapon>();
			for(Weapon w : bot.getMemory().getSeeReachableWeapons()) {
				if (!bot.getMemory().hasWeaponOfType(w.weaponType))
					seenWeapons.add(w);
			}
		
			seenItem = getNearestReachableItem(seenWeapons);
			if (seenItem != null) return true;

		
			// See ammo?
			List<Ammo> seenAmmos = new ArrayList<Ammo>();
			for(Ammo a : bot.getMemory().getSeeReachableAmmos()) {
				if (bot.getMemory().hasWeaponOfType(a.typeOfWeapon)) {
					AddWeapon weapon = bot.getMemory().getWeapon(a.typeOfWeapon);
					if (weapon.currentAmmo < weapon.maxAmmo)
						seenAmmos.add(a);
				}
			}
		
			seenItem = getNearestReachableItem(seenAmmos);
			if (seenItem != null) return true;
		
		
			// See other usefull item?
			List<Item> seenItems = new ArrayList<Item>();
//			This line is commented because of bug in pogamut.
//			seenItems.addAll(bot.getMemory().getSeeExtras());
			seenItems.addAll(bot.getMemory().getSeeArmors());
		
			seenItem = getNearestReachableItem(seenItems);
			return (seenItem != null);
		}
	}
	
	
	public boolean action_pickItemInSight()
	{
		synchronized(mutex) {
			if (seenItem != null) {
				log.fine("Bot tries to pick an item in his sight.");
				bot.getBody().runToLocation(seenItem.location);
				running = false;
			}
		}
		return true;
	}
	
	
	
	/*
	 * Others.
	 */
	
	public boolean sense_isShooting()
	{
		return bot.getMemory().isShooting();
	}
		
	public boolean action_stopShooting()
	{
		bot.getBody().stopShoot();
		return true;
	}

	public boolean sense_isBeingDamaged()
	{
		return bot.getMemory().isBeingDamaged();
	}
		
	public boolean action_turnAround()
	{
		bot.getBody().turnHorizontal(180);
		return true;
	}

	protected int stuckCounter = 0;
	
	public boolean sense_isStuck()
	{
		synchronized(mutex) {
			if (running && bot.getMemory().isColliding()) {
				log.fine("Bot is coliding (stuck counter " + stuckCounter + ").");
				stuckCounter++;
				return (stuckCounter > 0);
			} else {
				if (stuckCounter > 0) stuckCounter = 0;
				return false;
			}
		}
	}
	
	
	public boolean action_setBotFree()
	{
		synchronized(mutex) {
			log.fine("Bot is trying to set him free (stuck counter " + stuckCounter + ").");
			if (stuckCounter > 5) {
				bot.getBody().stop();
				running = false;
				stuckCounter = -10;
			
				// Run to med-kits patch.
				if (!runToMedKits.isEmpty())
					runToMedKits.remove(0);
			}
			if (stuckCounter > 4)
				bot.getBody().doubleJump();
		}
		return true;
	}
	
	
	protected ArrayList<Item> runAroundItems = null;
	protected ArrayList<Item> priorityList = new ArrayList<Item>();
	
	protected void shuffleList(ArrayList<Item> list)
	{
		if (list.size() < 2) return;
		int i = random.nextInt(list.size()-1) + 1;
		Item tmp = list.get(i);
		list.set(i, list.get(0));
		list.set(0, tmp);		
	}
	
	protected void prepareRunAroundItems()
	{
		if (runAroundItems != null)
			return;
		
		runAroundItems = new ArrayList<Item>();
		runAroundItems.addAll(bot.getMemory().getKnownWeapons());
		runAroundItems.addAll(bot.getMemory().getKnownAmmos());
		runAroundItems.addAll(bot.getMemory().getKnownArmors());
		runAroundItems.addAll(bot.getMemory().getKnownSpecials());
//		The following line is commented because of bug in pogamut.
//		runAroundItems.addAll(bot.getMemory().getKnownExtras());
		for (Health h : bot.getMemory().getKnownHealths())
			if (h.boostable) runAroundItems.add(h);

		shuffleList(runAroundItems);
	}
	
	protected int priorityListRefreshCounter = 0;
	
	protected void preparePriorityList()
	{
		priorityList.clear();
		for (Weapon w : bot.getMemory().getKnownWeapons())
			if (!bot.getMemory().hasWeaponOfType(w.weaponType))
				priorityList.add(w);
		shuffleList(priorityList);
		priorityListRefreshCounter = 5;
	}

	protected Item getActualWonderAroundItem()
	{
		if (!priorityList.isEmpty()) {
			log.fine("Wondering for priority item" + priorityList.get(0).UnrealID);
			return priorityList.get(0);
		} else {
			log.fine("Wondering for item" + runAroundItems.get(0).UnrealID);
			return runAroundItems.get(0);
		}
	}
	
	protected void nextWonderAroundItem()
	{
		if (priorityList.isEmpty()) {
			if (priorityListRefreshCounter <= 0)
				preparePriorityList();
			else
				priorityListRefreshCounter--;

			if (priorityList.isEmpty())
				shuffleList(runAroundItems);
		} else {
			priorityList.remove(0);
			shuffleList(priorityList);			
		}
	}
	
	public boolean action_wonderAround()
	{		
		synchronized(mutex) {
//			log.fine("The bot is wondering around at " + bot.getMemory().getAgentLocation());
			prepareRunAroundItems();
				
			if (!running) {
				if (!preparePathTo(getActualWonderAroundItem().navPoint)) {
					log.finer("The path initialization fails!");
					nextWonderAroundItem();
				} else
					running = true;
			}
		
			if (running && !bot.getMap().runAlongPath()) {
				log.finer("Running along the path terminated.");
				nextWonderAroundItem();
				running = false;
			}
		}
		return true;		

/*		
		NavPoint nav = null;
		for (NavPoint np : bot.getMemory().getKnownNavPoints())
			if (np.UnrealID.equals("DM-Flux2.JumpSpot8"))
				nav = np;
		if (nav != null) {
			for (NeighNav neigh : nav.neighbours) {
				log.finer("Neigh " + neigh.neighbour.UnrealID + " flags " + neigh.flags);
			}
		}
*/
	}
	
}
